<?php
/**
 * ProxStop Telephone Verification
 * @author tech@dayos.net
 */

// Load config & main class
require_once(__DIR__.'/../config.ProxStop.php');

$result = $ProxStop->telephoneStatus($_GET['ref'],isset($_GET['pin'])?$_GET['pin']:'');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ProxStop.com - Telephone Verification</title>
</head>
<body>
<div><a href="index.html">&larr; Back to Examples</a></div>
<h1>Telephone Verification</h1>
<?php

// The lookup failed, print the error message.
if($result===false)
{
?>
<div>The lookup failed with the error "<?php echo $ProxStop->errors['code']; ?>: <?php echo $ProxStop->errors['msg']; ?>"'</div>
<?php
}
else
{
	// Verify
	if(isset($_GET['act']) && $_GET['act']=='Verify')
	{
		// Pin entered good?
		if((string)$result->valid==='0')
		{
	?>
	<div>PIN entered good!</div>
	<hr />
	<?php
		}
		
		// Pin entered invalid?
		else
		{
	?>
	<div>PIN entered wrong!</div>
	<hr />
	<?php
		}
	}

?>
<div>Please wait, you will be called/texted shortly. Please enter the PIN number you receive below.</div>
<br />
<script src="../javascript/ProxStop.js" type="text/javascript"></script>
<form method="get" action="telephonecode.php" onsubmit="return ProxStop.validateTelephoneCode()">
<input type="hidden" name="ref" value="<?php echo isset($_GET['ref'])?$_GET['ref']:''; ?>" />
<table cellspacing="0" cellpadding="4" style="border:0px;">
	<tr>
		<td>Status:</td>
		<td><?php echo $ProxStop->telephoneStatus[(string)$result->status]; ?></td>
 	</tr>
	<tr>
		<td>PIN:</td>
		<td><input type="text" name="pin" id="pin" value="<?php echo isset($_GET['pin'])?$_GET['pin']:''; ?>" size="5" maxlength="5" /></td>
 	</tr>
	<tr>
		<td></td>
		<td><input type="submit" name="act" value="Verify" /></td>
	</tr>
</table>
<script type="text/javascript">
<!--
var ProxStop = new ProxStopClass();
-->
</script>
</form>
<?php
}
?>
</body>
</html>