<?php
/**
 * ProxStop Telephone Verification
 * @author tech@dayos.net
 */

// Load config & main class
require_once(__DIR__.'/../config.ProxStop.php');
require_once(__DIR__.'/../classes/ProxStop/Countries.php');
$countries = new ProxStop_Countries;
$defaultCountry = 'United States';
$error = '';

// Place Call
if(isset($_GET['act']) && ($_GET['act']=='Call Me' || $_GET['act']=='Text Me'))
{
	list($country,) = explode('_',$_GET['country']);
	$phone = $country==1?$_GET['phone1'].$_GET['phone2'].$_GET['phone3']:$_GET['phone'];
	$code = rand(10000,99999);
	$ext = $country==1?$_GET['ext']:$_GET['extIntl'];

	// Send Text
	if($_GET['act']=='Text Me')
		$result = $ProxStop->telephoneSMS($country,$phone,$code);
	
	// Call
	else
		$result = $ProxStop->telephoneCall($country,$phone,$code,$ext);
	
	// The lookup failed, print the error message.
	if($result===false)
		$error = 'The lookup failed with the error "'.$ProxStop->errors['code'].': '.$ProxStop->errors['msg'].'"';
	else
		exit(header('Location: telephonecode.php?ref='.$result->ref));
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ProxStop.com - Telephone Verification</title>
</head>
<body>
<div><a href="index.html">&larr; Back to Examples</a></div>
<h1>Telephone Verification</h1>
<?php
if($error!='')
{
?>
<div><?=$error?></div>
<hr />
<?php
}
?>
<div>Enter your telephone number below and you will receive an automated call that will provide you with a PIN number to verify the telephone number.</div>
<br />
<script src="../javascript/ProxStop.js" type="text/javascript"></script>
<form method="get" action="telephone.php" onsubmit="return ProxStop.validateTelephone()">
<table cellspacing="0" cellpadding="4" style="border:0px;">
	<tr>
		<td>Country:</td>
		<td>
			<select id="country" name="country" onchange="ProxStop.changeCountry()" onkeydown="ProxStop.changeCountry()" onkeyup="ProxStop.changeCountry()">
<?
if(!isset($_GET['country'])) $_GET['country'] = $countries->countries[$defaultCountry].'_'.$defaultCountry;
foreach($countries->countries as $name=>$code)
{
	$id = $code.'_'.$name;
?>
				<option value="<?php echo $code.'_'.$name; ?>"<?php echo isset($_GET['country']) && $_GET['country']==$id?' selected="selected"':''; ?>><?php echo $name; ?></option>
<?
}
?>
			</select>
    </td>
 	</tr>
	<tbody id="phoneNumberRow">
	<tr>
		<td>Phone Number:</td>
		<td>
			<input type="text" id="phone1" name="phone1" value="<?php echo isset($_GET['phone1'])?$_GET['phone1']:''; ?>" size="3" maxlength="3" onkeyup="return ProxStop.autoTabNum(this,3,'phone2');" />-<input type="text" id="phone2" name="phone2" value="<?php echo isset($_GET['phone2'])?$_GET['phone2']:''; ?>" size="3" maxlength="3" onkeyup="return ProxStop.autoTabNum(this,3,'phone3');" />-<input type="text" id="phone3" name="phone3" value="<?php echo isset($_GET['phone3'])?$_GET['phone3']:''; ?>" size="4" maxlength="4" onkeyup="return ProxStop.autoTabNum(this,4,'ext');" />
			Ext: 
			<input type="text" id="ext" name="ext" value="<?php echo isset($_GET['ext'])?$_GET['ext']:''; ?>" size="4" maxlength="4" onkeyup="ProxStop.checkExtension(this)" />
		</td>
	</tr>
	</tbody>
	<tbody id="phoneNumberIntlRow">
	<tr valign="top">
    <td>Phone Number:</td>
    <td>
			<div><small>*International customers, please don't enter a leading 0.</small></div>
			<span id="countryCodeIntl"></span>
			<input type="text" id="phone" name="phone" value="<?php echo isset($_GET['phone'])?$_GET['phone']:''; ?>" size="14" maxlength="14" onkeyup="return ProxStop.autoTabNum(this,14,'extIntl');" />
			Ext: 
			<input type="text" id="extIntl" name="extIntl" value="<?php echo isset($_GET['extInt'])?$_GET['extInt']:''; ?>" size="4" maxlength="4" onkeyup="ProxStop.checkExtension(this)" />
		</td>
	</tr>
	</tbody>
	<tr>
		<td></td>
		<td>
			<input type="submit" name="act" value="Call Me" />
			<input type="submit" id="textme" name="act" value="Text Me" />
		</td>
	</tr>
</table>
<script type="text/javascript">
<!--
var ProxStop = new ProxStopClass();
ProxStop.changeCountry();
-->
</script>
 </form>
<br />
<span style="color:#F00">Please note this example will use your actual ProxStop points.</span>
</body>
</html>