/**
 * ProxStop JavaScript Class
 * @author tech@dayos.net
 */
 
function ProxStopClass()
{
	/**
	 * Auto tab to the next field and filter only numbers
	 */
	this.autoTabNum = function(field,length,fieldNext)
	{
		// Filter out only numbers
		field.value = field.value.replace(/[^0-9]/,'');
		
		// Make sure it doesn't go back the max size
		field.value = field.value.slice(0,length);
		
		// Tab
		if(field.value.length==length)
			document.getElementById(fieldNext).focus();
	}

	/**
	 * Check if the country was changed to international
	 */
	this.changeCountry = function()
	{
		var country = document.getElementById('country').value.split('_');
		
		// The country is not international
		if(country[0]==1)
		{
			document.getElementById('phoneNumberRow').style.display = '';
			document.getElementById('phoneNumberIntlRow').style.display = 'none';
		}

		// The country is international
		else
		{
			document.getElementById('phoneNumberRow').style.display = 'none';
			document.getElementById('phoneNumberIntlRow').style.display = '';
			document.getElementById('countryCodeIntl').innerHTML = '+'+country[0];
		}
	}
	
	/**
	 * Check if the extension is filled out
	 */
	this.checkExtension = function(field)
	{
		document.getElementById('textme').disabled = field.value?true:false;
	}

	/**
	 * Check if an array contains a certain element
	 */
	this.containsElement = function(arr,ele)
	{
		var arrLength = arr.length;
		for(var i=0;i<arrLength;i++)
			if(arr[i]===ele)
				return true;
		return false;
	}

	/**
	 * Validate E-mail
	 */
	this.validateEmail = function()
	{
		if(!document.getElementById('email').value.match(/^([0-9a-zA-Z]+([_.-]?[0-9a-zA-Z]+)*@[0-9a-zA-Z]+[0-9,a-z,A-Z,.,-]*(.){1}[a-zA-Z]{2,4})+$/))
		{
			alert('The e-mail is not in a valid format.');
			document.getElementById('email').focus();
			return false;
		}
		
		// All Good
		return true;
	}

	/**
	 * Validate IP
	 */
	this.validateIP = function()
	{
		if(!document.getElementById('ip').value.match(/^((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})$/))
		{
			alert('The IP is not in a valid format.');
			document.getElementById('ip').focus();
			return false;
		}
		
		// All Good
		return true;
	}

	/**
	 * Validate Telephone Form
	 */
	this.validateTelephone = function()
	{
		var country = document.getElementById('country').value.split('_');

		// The country is not international
		if(country[0]==1)
		{
			for(var i=1;i<=3;i++)
			{
				if(document.getElementById('phone'+i.toString()).value=='')
				{
					alert('Please fully enter a phone number.');
					document.getElementById('phone'+i.toString()).focus();
					return false;
				}
			}
		}

		// The country is international
		else
		{
			if(document.getElementById('phone').value=='')
			{
				alert('Please enter a phone number.');
				document.getElementById('phone').focus();
				return false;
			}
		}
		
		// All Good
		return true;
	}
	
	/**
	 * Validate Telephone Code
	 */
	this.validateTelephoneCode = function()
	{
		if(document.getElementById('pin').value.length<3 || document.getElementById('pin').value.length>5)
		{
			alert('The PIN must be between 3 and 5 characters.');
			document.getElementById('pin').focus();
			return false;
		}
		
		// All Good
		return true;
	}
}