<?php
/**
 * ProxStop E-mail Lookup
 * @author tech@dayos.net
 */

// Load config & main class
require_once(__DIR__.'/../config.ProxStop.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ProxStop.com - E-mail Lookup</title>
</head>
<body>
<div><a href="index.html">&larr; Back to Examples</a></div>
<h1>E-mail Lookup</h1>
<?php

// Show Results?
if(isset($_GET['act']) && $_GET['act']=='Check')
{
	// Perform Lookup
	$email = isset($_GET['email'])?$_GET['email']:'';
	$result = $ProxStop->emailLookup($email);
	
	// The lookup failed, print the error message.
	if($result===false)
	{
?>
<div>The lookup failed with the error "<?php echo $ProxStop->errors['code']; ?>: <?php echo $ProxStop->errors['msg']; ?>"'</div>
<hr />
<?php
	}
	
	// Lets show the result since lookup was good.
	else
	{
?>
<div>E-mail: <?php echo $email; ?></div>
<div>Disposable: <?php echo $result->is_fraud; ?></div>
<hr />
<?php
	}
}

?>
<div>Check if an e-mail address is temporary/disposable.</div>
<br />
<script src="../javascript/ProxStop.js" type="text/javascript"></script>
<form method="get" action="email.php" onsubmit="return ProxStop.validateEmail()">
	E-mail Address:
	<input type="text" name="email" id="email" value="<?php echo isset($_GET['email'])?$_GET['email']:''; ?>" />
	<input type="submit" name="act" value="Check" />
</form>
<script type="text/javascript">
<!--
var ProxStop = new ProxStopClass();
-->
</script>
<br />
<span style="color:#F00">Please note this example will use your actual ProxStop points.</span>
</body>
</html>