<?php
/**
 * ProxStop IP Lookup
 * @author tech@dayos.net
 */

// Load config & main class
require_once(__DIR__.'/../config.ProxStop.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ProxStop.com - IP Lookup</title>
</head>
<body>
<div><a href="index.html">&larr; Back to Examples</a></div>
<h1>IP Lookup</h1>
<?php

// Show Results?
if(isset($_GET['act']) && $_GET['act']=='Get Score')
{
	// Perform Lookup
	$ip = isset($_GET['ip'])?$_GET['ip']:'';
	$result = $ProxStop->proxyLookup($ip);
	
	// The lookup failed, print the error message.
	if($result===false)
	{
?>
<div>The lookup failed with the error "<?php echo $ProxStop->errors['code']; ?>: <?php echo $ProxStop->errors['msg']; ?>"'</div>
<hr />
<?php
	}
	
	// Lets show the result since lookup was good.
	else
	{
?>
<div>IP: <?php echo $ip; ?></div>
<div>Score: <?php echo $result->score; ?> - <?php echo $ProxStop->proxyScoreRisk[(string)$result->score]; ?></div>
<hr />
<?php
	}
}

?>
<div>Get the score of an IP address to help determine if it's a proxy.</div>
<br />
<script src="../javascript/ProxStop.js" type="text/javascript"></script>
<form method="get" action="ip.php" onsubmit="return ProxStop.validateIP()">
	IP Address:
	<input type="text" id="ip" name="ip" value="<?php echo isset($_GET['ip'])?$_GET['ip']:(isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:''); ?>" />
	<input type="submit" name="act" value="Get Score" />
</form>
<script type="text/javascript">
<!--
var ProxStop = new ProxStopClass();
-->
</script>
<br />
<span style="color:#F00">Please note this example will use your actual ProxStop points.</span>
</body>
</html>