<?php
/**
 * ProxStop Telephone Lookup
 * @author tech@dayos.net
 */

// Load config & main class
require_once(__DIR__.'/../config.ProxStop.php');
require_once(__DIR__.'/../classes/ProxStop/Countries.php');
$countries = new ProxStop_Countries;
$defaultCountry = 'United States';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ProxStop.com - Telephone Lookup</title>
</head>
<body>
<div><a href="index.html">&larr; Back to Examples</a></div>
<h1>Telephone Lookup</h1>
<?php

// Place Call
if(isset($_GET['act']) && $_GET['act']=='Lookup')
{
	list($country,) = explode('_',$_GET['country']);
	$phone = $country==1?$_GET['phone1'].$_GET['phone2'].$_GET['phone3']:$_GET['phone'];\
	$result = $ProxStop->telephoneLookup($country,$phone);
	
	// The lookup failed, print the error message.
	if($result===false)
	{
?>
<div>The lookup failed with the error "<?php echo $ProxStop->errors['code']; ?>: <?php echo $ProxStop->errors['msg']; ?>"'</div>
<hr />
<?php
	}
	else
	{
?>
<div>Country: <?php echo $result->country; ?></div>
<div>Original Number: <?php echo $result->ophone; ?></div>
<div>Cleansed Number: <?php echo $result->cphone; ?></div>
<div>Cleansing Code: <?php echo $result->ccode; ?> - <?php echo $ProxStop->telephoneCleansed[(string)$result->ccode]; ?></div>
<div>City: <?php echo $result->city; ?></div>
<div>State: <?php echo $result->state; ?></div>
<div>Zip: <?php echo $result->zip; ?></div>
<div>County: <?php echo $result->county; ?></div>
<div>Country Abbr: <?php echo $result->countryabbr; ?></div>
<div>Country Name: <?php echo $result->countryname; ?></div>
<div>Time Zone: <?php echo $result->timezone; ?></div>
<div>UTC Min: <?php echo $result->utcmin; ?></div>
<div>UTC Max: <?php echo $result->utcmax; ?></div>
<div>Latitude: <?php echo $result->lat; ?></div>
<div>Longitude: <?php echo $result->lon; ?></div>
<div>Min: <?php echo $result->min; ?></div>
<div>Max: <?php echo $result->max; ?></div>
<div>Type: <?php echo $result->type; ?> - <?php echo $ProxStop->telephoneTypes[(string)$result->type]; ?></div>
<hr />
<?php
	}
}

?>
<div>Get detailed information on a specific telephone number. The lookup tool can also be used to filter out phone numbers that are VoIP or any other type of number you wish to prohibit.</div>
<br />
<script src="../javascript/ProxStop.js" type="text/javascript"></script>
<form method="get" action="telephonelookup.php" onsubmit="return ProxStop.validateTelephone()">
<table cellspacing="0" cellpadding="4" style="border:0px;">
	<tr>
		<td>Country:</td>
		<td>
			<select id="country" name="country" onchange="ProxStop.changeCountry()" onkeydown="ProxStop.changeCountry()" onkeyup="ProxStop.changeCountry()">
<?
if(!isset($_GET['country'])) $_GET['country'] = $countries->countries[$defaultCountry].'_'.$defaultCountry;
foreach($countries->countries as $name=>$code)
{
	$id = $code.'_'.$name;
?>
				<option value="<?php echo $code?>_<?php echo $name?>"<?php echo isset($_GET['country']) && $_GET['country']==$id?' selected="selected"':''?>><?php echo $name?></option>
<?
}
?>
			</select>
    </td>
 	</tr>
	<tbody id="phoneNumberRow">
	<tr>
		<td>Phone Number:</td>
		<td>
			<input type="text" id="phone1" name="phone1" value="<?php echo isset($_GET['phone1'])?$_GET['phone1']:''; ?>" size="3" maxlength="3" onkeyup="return ProxStop.autoTabNum(this,3,'phone2');" />-<input type="text" id="phone2" name="phone2" value="<?php echo isset($_GET['phone2'])?$_GET['phone2']:''; ?>" size="3" maxlength="3" onkeyup="return ProxStop.autoTabNum(this,3,'phone3');" />-<input type="text" id="phone3" name="phone3" value="<?php echo isset($_GET['phone3'])?$_GET['phone3']:''; ?>" size="4" maxlength="4" onkeyup="return ProxStop.autoTabNum(this,4,'lookup');" />
		</td>
	</tr>
	</tbody>
	<tbody id="phoneNumberIntlRow">
	<tr valign="top">
    <td>Phone Number:</td>
    <td>
			<div><small>*International customers, please don't enter a leading 0.</small></div>
			<span id="countryCodeIntl"></span>
			<input type="text" id="phone" name="phone" value="<?php echo isset($_GET['phone'])?$_GET['phone']:''; ?>" size="14" maxlength="14" onkeyup="return ProxStop.autoTabNum(this,14,'lookup');" />
		</td>
	</tr>
	</tbody>
	<tr>
		<td></td>
		<td><input type="submit" name="act" value="Lookup" id="lookup" /></td>
	</tr>
</table>
<script type="text/javascript">
<!--
var ProxStop = new ProxStopClass();
ProxStop.changeCountry();
-->
</script>
 </form>
<br />
<span style="color:#F00">Please note this example will use your actual ProxStop points.</span>
</body>
</html>